   SUBROUTINE GETWDS
      USE ALLCOM
      
      SAVE SAY_WHAT

!     CHECKS IF PREVIOUS WORDS VECTOR IS EMPTY, READ A LINE AND CHECK EACH WORD FOR INTELLIGIBILITY.
!     IF THE WORD IS VALID, ITS NUMBER GETS STUCK INTO THE WORDS VECTOR AND EACH WORD IS PARSED BY THE APPROPRIATE CODE.

!        TXT(WDX)              HOLD THE RAW TEXT FROM GETLIN
!        WORDS(WDX)            LIST OF WORD NUMBERS, CONVERTED FROM TXT(WDX).
!        VTXT(VRBX)            HOLD THE TEXT FOR VERB VRBX.
!        VERBS(VRBX)           IS THE LIST OF VALIDATED VERB NUMBERS.
!        OTXT(OBJX)            HOLDS THE TEXT OF THE OBJECT OBJX.
!        OBJX(OBJX)            IS THE LIST OF VALIDATED OBJECT NUMBERS.
!        IOTXT(IOBX)           HOLDS THE TEXT FOR PREP'S IOBJ.
      
!     ACTION VERBS NOT IN COMMON, AND CLASS TYPE VALUES:
      
      INTEGER, PARAMETER:: ENTER=3,ALL=109,DROPIT=2,FEED=21,NOTHNG=5,LIGHT=7,DRINK=15,SCORE_IT=24,PICK=41,PUT=42,GET=44,SACK=108,&
                           CLASS_MOTION=1,CLASS_NOUN=2,CLASS_ACTION=3,CLASS_MISC=4,CLASS_CONJ=7,CRAWL=17,JUMP=39,CLIMB=56

      INTEGER I,VOCABX,WORD,KK,CLASS,WCLASS,K,VAL,LIQLOC,VRBKEY,NOWAY,CONFUZ,TAKDIR(20)
      
      LOGICAL BLIND,LIVING,PFLAG,HINGED,AT,ATHAND,TOTING,K1,SAY_WHAT,AJAR
      
      CHARACTER(6) WORD1,WORD2,ZAPP*72
      
!     TAKDIR IS A LIST OF MOTION VERBS WHICH ARE ACCEPTABLE AFTER 'TAKE'.

      DATA TAKDIR/2,6,9,10,11,13,14,17,23,25,33,34,36,37,39,78,79,80,89,-1/
      
      DATA SAY_WHAT/.FALSE./
      
!     IF WORDS(WDX+1) HAS SOMETHING IN IT, WE ARE STILL PROCESSING OLD INPUT LINE.  IF WORDS(1) WAS SET TO -2, SOMEONE ELSE
!     HAS ALREADY READ IN THE NEW LINE, PRESUMABLY TO CHECK FOR SOME NON-STANDARD WORD, E.G., KILLING DRAGON WITH BARE HANDS.

      POUR=13
      IF (WORDS(WDX+1).GT.0) GO TO 30

20    IF (WORDS(1).NE.-2) CALL GETLIN
      IF (SAY_WHAT) THEN
         IF (TXT(1).NE.'SAY') THEN
            DO I=35,2,-1
               TXT(I)=TXT(I-1)
            END DO
            TXT(1)='SAY'
         ENDIF
      ENDIF
      WDX=0
      DO I=1,35
         WORDS(I)=0
         IF (TXT(I).NE.' ') WORDS(I)=VOCABX(TXT(I),-1)
      END DO

!     THE FIRST WORD OF EACH CLAUSE GETS SPECIAL CHECKING, MOSTLY LOOKING FOR IDIOMS.

!     SPECIAL HANDLING FOR 'SAY' AND 'CALL'.  WIN IF SAYING/CALLING MAGIC WORDS.
!     NARKY IF UTTERING ANYTHING ELSE.  IF NO OBJ, PASS ON FOR HIGHER LEVEL PARSING.

   30 PFLAG=.FALSE.
      WDX=WDX+1
      WORD=WORDS(WDX)
      IF (WORD.LT.0) GO TO 830
      IF (WORD.EQ.0) GO TO 800

      KK=CLASS(WORD)
      IF (KK.EQ.-1) GO TO 91
      IF (KK.EQ.CLASS_ACTION.OR.KK.EQ.CLASS_MOTION.OR.KK.EQ.CLASS_MISC) CALL CLRLIN
      K=VAL(WORD)
      IF (KK.EQ.CLASS_ACTION.AND.(K.EQ.SAY.OR.K.EQ.YELL)) THEN

!        'SAY' OR 'CALL'.  IF NO NEXT WORD, PASS ON TO HIGHER POWERS.
!        IF OBJECT IS MAGIC WORD ('SAY XYZZY'), FLUSH 'SAY' & TAKE NEXT WORD.

         IF (WORDS(WDX+1).EQ.0.OR.CLASS(WORDS(WDX+1)).EQ.CLASS_CONJ) THEN
            SAY_WHAT=.TRUE.
            GO TO 99
         ENDIF
         SAY_WHAT=.FALSE.
         WDX=WDX+1
         ZAPP='"'//TXT(WDX)
         DO I=1,34
            KK=LEN_TRIM(ZAPP)+2
            IF (KK.GT.60.OR.TXT(I).EQ.' ') EXIT
            ZAPP(KK:)=TXT(WDX+I)
         END DO  
         IF (K.EQ.YELL) THEN
            ZAPP(LEN_TRIM(ZAPP)+1:)='!!!!!"'
            CALL UPPER_CASE(ZAPP)
         ELSE
            ZAPP(LEN_TRIM(ZAPP)+1:)='."'
            CALL LOWER_CASE(ZAPP)
         ENDIF
         WORD=WORDS(WDX)
         IF (WORD.EQ.62.OR.WORD.EQ.65.OR.WORD.EQ.71.OR.WORD.EQ.82.OR.WORD.EQ.2025) GO TO 99
         WRITE(*,"(A)") ZAPP
         GO TO 860
      ENDIF

!     SPECIAL STUFF FOR 'ENTER'.  CAN'T GO INTO WATER. 'ENTER BOAT' MEANS 'TAKE BOAT'.

      WORD1=TXT(WDX)
      WORD2=TXT(WDX+1)
      IF (WORD1.EQ.'ENTER') THEN
         IF (WORD2.EQ.' ') GO TO 91
         SPK=43
         IF (LIQLOC().EQ.WATER) SPK=70
         IF (INDEX('STREAM WATER RESERV OCEAN SEA POOL',WORD2).GT.0) GO TO 810
         IF (WORD2.EQ.'BOAT'.OR.WORD2.EQ.'ROWBOA') WORD=TAKE+2000
         GO TO 99
      ENDIF

!     'LEAVE' IS A MOTION VERB UNLESS LEAVING AN OBJECT, E.G., 'LEAVE BOAT' OR 'LEAVE BOTTLE', BUT ONLY TOTABLE OBJECTS.

      KK=WORDS(WDX+1)
      IF (WORD1.EQ.'LEAVE'.AND.CLASS(KK).EQ.CLASS_NOUN) THEN
         IF (HINGED(VAL(KK)).OR.FIXED(VAL(KK)).NE.0) GO TO 99
         WORD=LEAVE+2000
      ELSEIF (WORD1.EQ.'LIGHT'.AND.WORDS(WDX+1).EQ.(LAMP+1000)) THEN
         WORD=LIGHT+2000   !IF 'LIGHT LAMP', LIGHT MUST BE TAKEN AS AN ACTION VERB, NOT A NOUN.
      ELSE
         IF ((WORD1.NE.'WATER'.AND.WORD1.NE.'OIL').OR.(WORD2.NE.'PLANT'.AND.WORD2.NE.'DOOR'.AND.WORD2.NE.'SWORD '&
                               .AND.WORD2.NE.'ANVIL')) GO TO 65
         IF (AT(VOCABX(WORD2,CLASS_NOUN))) THEN
            WORDS(WDX+1)=WORDS(WDX)
            TXT(WDX+1)=TXT(WDX)
         ENDIF
         WORD=POUR+2000    !'WATER PLANT' BECOMES 'POUR WATER', IF WE ARE AT PLANT. 'OIL DOOR' BECOMES 'POUR OIL', ETC., ETC.
      ENDIF
      GO TO 99

!     CHECK EMPTYING A CONTAINER.

65    IF ((WORD1.EQ.'EMPTY ').AND.(CLASS(WORDS(WDX+1)).EQ.CLASS_NOUN)) THEN
         KK=VAL(WORDS(WDX+1))
         IF (KK.EQ.SACK.OR.KK.EQ.SAFE.OR.KK.EQ.BOAT.OR.KK.EQ.CHEST) THEN
            IF (PLACE(KK).NE.LOC) GO TO 91
            IF (.NOT.AJAR(KK)) THEN
!               CALL SPEAK(RTEXT(358))
               GO TO 91
            ENDIF
            K=0
            DO I=1,MAXOBJ
               IF (PLACE(I).EQ.-KK)  THEN
                  CALL REMOVE(I)
                  CALL DROP(I,LOC)
                  CALL PSPEAK(I,-1)
                  INDENT=1; BLKLIN=.FALSE.
                  CALL SPEAK(RTEXT(344))
                  BLKLIN=.TRUE.
                  K=I
               ENDIF  
            END DO
         ENDIF
         IF (K.EQ.0) CALL SPEAK(RTEXT(378))
         GO TO 20
      ENDIF
      GO TO 91

!     THIS IS THE 'INNER' LOOP.  DISPATCHING OF ALL WORDS IN A CLAUSE AFTER THE FIRST COMES HERE.

90    WDX=WDX+1
      WORD=WORDS(WDX)
91    IF (WORD.LT.0) GO TO 830
      IF (WORD.EQ.0) GO TO 900
      GO TO 92

96    WCLASS=WCLASS+1
      WORD=VOCABX(TXT(WDX),-(WCLASS+1))
      IF (WORD.EQ.-1) GO TO 800
      WORDS(WDX)=WORD
92    IF (CLASS(WORD).NE.CLASS_NOUN) GO TO 99

!     IT'S NOT THE FIRST: MAKE SURE A COMMA OR 'AND' USED. DIFFERENTIATE BETWEEN DIR & INDIR OBJECTS.
!     CHECK FOR SPECIAL CASE OF MULTIPLE OBJECTS: 'FEED BEAR HONEY' OR'THROW TROLL NUGGET'.

      K=OBJX
      IF (PFLAG)K=IOBX
      IF (K.NE.0) THEN
         IF (WDX.GT.1) THEN
            IF (CLASS(WORDS(WDX-1)).EQ.CLASS_CONJ) GO TO 99
         ENDIF
         KK=0
         IF (VRBX.GT.0) KK=VAL(VERBS(VRBX))
         IF (.NOT.LIVING(OBJS(OBJX)).OR.(KK.NE.THROW.AND.KK.NE.FEED)) GO TO 800
         IOBX=IOBX+1
         IOBJS(IOBX)=OBJS(OBJX)
         OBJS(OBJX)=0
         OBJX=OBJX-1
      ENDIF

99    WCLASS=CLASS(WORD)
      SELECT CASE (WCLASS)
         CASE (1); GO TO 100  !MOTION
         CASE (2); GO TO 200  !OBJ (NOUN)
         CASE (3); GO TO 300  !ACTION
         CASE (4); GO TO 400  !MISC
         CASE (5); GO TO 500  !PREPOSITION
         CASE (6); GO TO 600  !ADJECTIVE
         CASE (7); GO TO 700  !CONJ
      END SELECT
      CALL BUG('UNKNOWN WORD CLASS IN GETWDS')
       
!     MOTION VERB.

!     EITHER A DIRECTION ('WEST') OR A MOTION ('JUMP'). MULTIPLE MOTIONS MUST BE SEPARATED BY COMMAS OR AND'S.
!     THERE ARE SOME IDIOMATIC USES WHICH MUST BE SCANNED FOR, SUCH AS 'TAKE BRIDGE', WHICH BECOMES 'BRIDGE' AND 'GO WEST', 
!     WHICH BECOMES 'WEST', AND 'LEAVE THING' IS DIFFERENT FROM JUST 'LEAVE'.

!     IF ORIGINAL VERB WAS 'GO', FLUSH IT & REPLACE WITH THIS ONE. I.E., 'GO WEST' BECOMES 'WEST'.

!     CHECK TAKDIR(20) LIST FOR VALID OBJECT MOTION VERBS FOR 'TAKE'.  IF FOUND, THROW AWAY 'TAKE' AND USE THE MOTION VERB.

!     SINCE THE ORIGINAL VERB IS AN ACTION VERB, CHECK IF IN NOUN TABLE.  MAYBE IT IS AN OBJECT SYNONYMOUS WITH A VERB ('ROCKS').

!     IF NOT A VALID MOTION-OBJECT OF 'TAKE' OR 'GO', NOR AN OBJECT, CHECK PREP TABLE. IF FOUND, HAND TO THE PREPOSITION ANALYZER.

100   IF (VRBX.EQ.0) GO TO 180
      K=VERBS(VRBX)
      IF (CLASS(K).GT.CLASS_ACTION) GO TO 800
      IF (CLASS(K).EQ.CLASS_ACTION) THEN
         IF (VAL(K).EQ.GO) GO TO 180

         IF (VAL(K).EQ.TAKE) THEN
            KK=VAL(WORD)
            DO I=1,20
               IF (TAKDIR(I).EQ.KK) GO TO 180
            END DO
         ENDIF
         GO TO 96
      ENDIF

!     IF ORIGINAL MOTION VERB WAS CRAWL, JUMP OR CLIMB, IGNORE CURRENT WORD; 'CLIMB UP' OR 'JUMP OVER' BECOME 'CLIMB' & 'JUMP' ONLY.

      IF (K.EQ.CRAWL.OR.K.EQ.JUMP.OR.K.EQ.CLIMB) GO TO 90

180   VERBS(1)=WORD
      VRBX=1
      IF (TXT(WDX).EQ.'WEST') THEN
         IWEST=IWEST+1
         IF (IWEST.EQ.10) CALL SPEAK(RTEXT(17))
         K=VAL(WORD)
         IF (K.EQ.EXIT.OR.K.EQ.ENTER) GO TO 860
      ENDIF
      GO TO 90
       
!     ANALYZE OBJECT.  IF PFLAG IS TRUE, THEN WE ARE PROCESSING A SET OF INDIRECT (PREP) OBJECTS, NOT DIRECT OBJS.

200   IF (PFLAG) GO TO 503
      IF (VRBX.EQ.0) THEN
         K=VOCABX(TXT(WDX),-(CLASS_ACTION+1))
         IF (K.NE.-1) THEN
            WORD=K
            GO TO 300
         ENDIF
      ENDIF

      WORD=VAL(WORD)
      IF (WORD.EQ.ALL) GO TO 280
      CALL GETOBJ(WORD)
      IF (WORD.EQ.0) GO TO 860
      IF (WORD.LT.0) THEN
         WORD=-WORD           !IT WASN'T REALLY AN OBJECT.  GO SEE WHAT IT WAS.
         GO TO 99
      ENDIF

!     IT WAS REALLY AN OBJECT & IT IS HERE.

      OBJX=OBJX+1
      OBJS(OBJX)=WORD
      OTXT(OBJX)=TXT(WDX)
      GO TO 90

!     TAKE EVERYTHING NOT BATTENED DOWN.

280   KK=VAL(VERBS(VRBX))
      K1=.FALSE.
      IF (KK.NE.DROPIT.AND.KK.NE.PUT.AND.KK.NE.LEAVE) THEN
         K1=.TRUE.
         IF (KK.NE.TAKE.AND.KK.NE.PICK.AND.KK.NE.GET) GO TO 800
         SPK=357
         IF (BLIND()) GO TO 810
      ENDIF
      DO I=1,MAXOBJ
         IF (.NOT.ATHAND(I).OR.FIXED(I).NE.0) CYCLE
         IF (I.GE.WATER.AND.I.LE.WINE+1) CYCLE
         IF ((K1.AND.TOTING(I)) .OR. (.NOT.K1.AND..NOT.TOTING(I)) ) CYCLE
         OBJX=OBJX+1
         OBJS(OBJX)=I
         IF (OBJX.EQ.45) EXIT    !MOST WE CAN HOLD
      END DO
      DO I=1,OBJX
         IF (OBJS(I).EQ.CHEST) THEN
            OBJS(I)=OBJS(1)
            OBJS(1)=CHEST
         ENDIF
      ENDDO
      GO TO 90
      
!     ACTION VERB.

300   IF (VRBX.NE.0) THEN
         IF (VAL(VERBS(VRBX)).EQ.TAKE) THEN
            K=VAL(WORD)
            IF (K.EQ.DRINK.OR.K.EQ.INVENT.OR.K.EQ.SCORE_IT.OR.K.EQ.NOTHNG.OR.K.EQ.LOOK) GO TO 371
            IF (K.NE.GO) GO TO 800
            IF (TXT(WDX).EQ.'WALK'.OR.TXT(WDX).EQ.'RUN'.OR.TXT(WDX).EQ.'HIKE')  GO TO 371
            GO TO 800
         ENDIF
         IF (OBJX.NE.0.OR.CLASS(WORDS(WDX-1)).NE.CLASS_CONJ) GO TO 800
      ENDIF

      VRBX=VRBX+1
371   VERBS(VRBX)=WORD
      VTXT(VRBX)=TXT(WDX)
      GO TO 90

!     MISCELLANEOUS WORDS/VERBS.

400   IF (VRBX.NE.0) GO TO 800
      VERBS(1)=WORD
      VRBX=1
      GO TO 90
       
!     ANALYZE A PREPOSITION AND ITS OBJECT.  CHECK VALIDITY FOR THIS VERB, THEN CHECK OBJECT IS VALID FOR PREPOSITION.
!     IF FIRST CHECK FAILS, SYNTAX IS MESSED UP; IF SECOND PART FAILS, IT MAY MERELY BE AN IMPOSSIBLE ACT.

500   IF (VRBX.EQ.0) GO TO 800
      IF (CLASS(VERBS(VRBX)).NE.CLASS_ACTION.OR.IOBX.NE.0) GO TO 800
      IF (PFLAG) GO TO 503
      VRBKEY=VKEY(VAL(VERBS(VRBX)))
      IF (VRBKEY.EQ.0) GO TO 800
      PREP=VAL(WORD)
      PFLAG=.TRUE.
      WDX=WDX+1
      WORD=WORDS(WDX)
      IF (WORD.EQ.0) GO TO 510
      SELECT CASE (CLASS(WORD))
         CASE (1,3:5); GO TO 800
         CASE (2); GO TO 503
         CASE (6); GO TO 600
         CASE (7); GO TO 510
      END SELECT
      GO TO 830

503   WORD=VAL(WORD)
      IF (WORD.NE.ALL) THEN
         CALL GETOBJ(WORD)
         IF (WORD.LT.0) GO TO 570
         IF (WORD.EQ.0) GO TO 860
         IOBX=IOBX+1
         IOBJS(IOBX)=WORD
         IOTXT(IOBX)=TXT(WDX)
      ENDIF
510   KK=IABS(PTAB(VRBKEY)/1000)
      IF (KK.EQ.PREP) THEN

!        PREP IS VALID WITH THIS VERB.  NOW CHECK OBJECT OF PREP.

         IF (WORD.EQ.0.OR.CLASS(WORD).EQ.CLASS_CONJ) GO TO 530

!        AN OBJ FOLLOWS THE PREP.  SEE IF IT'S PLAUSIBLE.

         KK=IABS((MOD(PTAB(VRBKEY),0001000)))
         IF (KK.EQ.WORD.AND.KK.EQ.ALL) GO TO 280
         IF (KK.EQ.WORD.OR.KK.EQ.999) GO TO 90
      ENDIF
      
      VRBKEY=VRBKEY+1
      IF (PTAB(VRBKEY-1).GE.0) GO TO 510
      GO TO 570

!     NO OBJ FOLLOWS PREP.  CHECK SPECIAL CASES.

530   PFLAG=.FALSE.
      WDX=WDX-1
      IF (OBJX.EQ.0) GO TO 570
      IF ((TXT(WDX).NE.'ON'.AND.TXT(WDX).NE.'OFF').AND.(VTXT(VRBX).NE.'TURN'.OR.OBJS(OBJX).NE.LAMP).AND.(VTXT(VRBX).NE.'TAKE'.AND.&
         VTXT(VRBX).NE.'PUT')) GO TO 570
      IF ((TXT(WDX).EQ.'UP'.AND.VTXT(VRBX).NE.'PICK').OR.(TXT(WDX).EQ.'DOWN'.AND.(VTXT(VRBX).NE.'PUT'.AND.VERBS(VRBX).NE.THROW)))&
          GO TO 570
      WDX=WDX+1
      WORD=WORDS(WDX)
      IF (WORD.EQ.0) GO TO 900
      IF (CLASS(WORD).NE.CLASS_CONJ) GO TO 800
      GO TO 91

!     CAN'T DO THAT!!

570   SPK=NOWAY()
      GO TO 810
       
!     ADJECTIVE HANDLER; GET NEXT WORD, MAKE SURE VALID FOR THIS ADJ. CALL GETOBJ TO SEE IF REALLY THERE AND LINK INTO OBJ CODE.

600   ADJ=VAL(WORD)
      WDX=WDX+1
      WORD=WORDS(WDX)
      IF (WORD.LT.0) GO TO 830
      IF (WORD.NE.0) THEN
         IF (CLASS(WORD).NE.CLASS_CONJ) THEN
            IF (CLASS(WORD).NE.CLASS_NOUN) WORD=VOCABX(TXT(WDX),-(CLASS_NOUN+1))
            IF (WORD.EQ.-1.OR.CLASS(WORD).NE.CLASS_NOUN.OR.VAL(WORD).EQ.ALL) GO TO 800
            WORDS(WDX)=WORD
            KK=VAL(WORD)
            K=ADJKEY(ADJ)
610         IF (KK.EQ.IABS(ADJTAB(K)) ) GO TO 92
            IF (ADJTAB(K).LT.0) GO TO 800
            K=K+1
            GO TO 610
         ENDIF
      ENDIF

      ZAPP=TXT(WDX-1);  ZAPP(LEN_TRIM(ZAPP)+1:)=' what?'
      CALL LOWER_CASE(ZAPP)
      WRITE(*,"(1X, A)") ZAPP
      GO TO 20

!     ANALYZE CONJUNCTION.  MAY BE COMMA OR EXPLICIT "AND". LOOK AHEAD AT NEXT WORD.  IF AN ACTION VERB AND NO OBJECT SPECIFIED, 
!     PUT IT ON STACK.  IF IT IS AN OBJECT, ADD IT TO THE PILE.  ELSE, BUMP BACK THE WORD POINTER, ASSUME END OF CLAUSE, AND RETURN.

700   WDX=WDX+1
      WORD=WORDS(WDX)
      IF (WORD.LT.0) GO TO 830
      IF (WORD.EQ.0) GO TO 800

      SELECT CASE (CLASS(WORD))
         CASE (1,4); GO TO 790
         CASE (2,6); GO TO 92
         CASE (3); GO TO 720
         CASE (5,7)
      END SELECT

!     A NEW ACTION VERB FOLLOWS.  IF NO PREVIOUS VERB WAS TYPED OR IF PREVIOUS VERB NOT AN ACTION VERB--FAILS.
!     IF AN OBJ/IOBJ WAS SPECIFIED FOR PREV ACT VERB--FAILS.  ONLY VALID SYNTAX IS: 'GET AND OPEN CAGE'.

720   IF (VRBX.NE.0.AND.CLASS(VERBS(VRBX)).EQ.CLASS_ACTION.AND.OBJX.EQ.0.AND.IOBX.EQ.0) GO TO 92

790   WDX=WDX-1
      GO TO 900
      
!     GEE, I DON'T UNDERSTAND.  FLUSH REST OF CURRENT CLAUSE UP TO EOL OR CONJUNCTION & CONTINUE.

800   SPK=CONFUZ()
810   CALL SPEAK(RTEXT(SPK))
      CALL CLRLIN
      GO TO 20

!     AN IRREGULAR WORD WAS TYPED IN

 830  ZAPP=TXT(WDX)
      CALL LOWER_CASE(ZAPP)
      ZAPP(LEN_TRIM(ZAPP)+1:)='.'
      WRITE(*,"(/' I don''t understand the word ',A)") ZAPP
      CALL CLRLIN
      GO TO 20

!     SCAN TO CONJ OR END OF LINE.

860   CALL CLRLIN
      PFLAG=.FALSE.
862   WDX=WDX+1
      IF (WORDS(WDX).EQ.0) GO TO 20
      IF (CLASS(WORDS(WDX)).EQ.CLASS_CONJ) GO TO 90
      GO TO 862

!     END OF CLAUSE; WE APPEAR TO HAVE REACHED THE END OF A SENTENCE TERMINATED BY CRLF OR A CONJUNCTION. IF CONJ, THE CONJ ANALYZER
!     CLAIMS THAT NEXT WORDS ARE NOT PART OF THIS CLAUSE.  DECIDE IF ENOUGH TO WORK WITH.

900   PFLAG=.FALSE.
      IF (VERBS(1).EQ.0) THEN
         IF (OBJS(1).EQ.0) GO TO 800
         IF (OBJS(2).EQ.0) THEN
            ZAPP=OTXT(1);  ZAPP(LEN_TRIM(ZAPP)+1:)='?'
            CALL LOWER_CASE(ZAPP)
            WRITE(*,"(/' What do you want to do with the ',A)") ZAPP
         ELSE
            WRITE(*,"(/' What do you want to do with them')")
         ENDIF
         GO TO 20
      ENDIF
      IF (OBJX.GT.1.AND.IOBX.GT.1) GO TO 800

      END